/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.quickhomes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.quickhomes.IStoreHome;
import dev.itsmeow.quickhomes.forge.QuickHomesModImpl;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class QuickHomesMod {
    public static final String MOD_ID = "quickhomes";
    public static final String CONFIG_FIELD_NAME = "enable_join_message";
    public static final String CONFIG_FIELD_COMMENT = "Set to false to disable join message.";
    public static final boolean CONFIG_FIELD_VALUE = true;

    public static void registerCommands(CommandDispatcher dispatcher) {
        Predicate<CommandSourceStack> isPlayer = source -> {
            try {
                return source.m_81375_() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        };
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"home").requires(isPlayer)).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            Pair<Vec3, ResourceKey<Level>> home = ((IStoreHome)player).getHome();
            if (home.getLeft() != null && home.getRight() != null) {
                player.m_8999_(player.m_20194_().m_129880_((ResourceKey)home.getRight()), ((Vec3)home.getLeft()).f_82479_, ((Vec3)home.getLeft()).f_82480_, ((Vec3)home.getLeft()).f_82481_, player.m_146908_(), player.m_146909_());
                return 1;
            }
            player.m_6352_((Component)new TextComponent("No home set."), Util.f_137441_);
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sethome").requires(isPlayer)).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            ((IStoreHome)player).setHome(new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()), (ResourceKey<Level>)player.m_183503_().m_46472_());
            player.m_6352_((Component)new TextComponent("Home set."), Util.f_137441_);
            return 1;
        }));
    }

    public static void onPlayerJoin(Player player) {
        if (!player.f_19853_.m_5776_() && QuickHomesMod.isJoinMessageEnabled()) {
            player.m_6352_((Component)new TextComponent("This server is running QuickHomes " + QuickHomesMod.getModVersion() + " by itsmeowdev!"), Util.f_137441_);
            player.m_6352_((Component)new TextComponent("You can use /sethome and /home with this mod installed."), Util.f_137441_);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isJoinMessageEnabled() {
        return QuickHomesModImpl.isJoinMessageEnabled();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion() {
        return QuickHomesModImpl.getModVersion();
    }
}

